--- Function to Make VSP Vehicles Material
fn DYNFUNmakeCivilViewVehicles FUNpath =
(
  local LOCmat

  --- Open CivilViewSurfaces Material Library File
  local LOCcivilViewVehiclesMatFile = "$matlibs\\" + DYNmatNameVehicles + ".mat"
  local LOCcivilViewVehiclesMatLib  = loadTempMaterialLibrary LOCcivilViewVehiclesMatFile

  if doesFileExist LOCcivilViewVehiclesMatFile and LOCcivilViewVehiclesMatLib != undefined then
  (
    for i = 1 to LOCcivilViewVehiclesMatLib.count do
    (
      if LOCcivilViewVehiclesMatLib[i].name == DYNmatNameVehicles and classOf LOCcivilViewVehiclesMatLib[i] == Multimaterial then LOCmat = LOCcivilViewVehiclesMatLib[i]
    )
  )

  --- If It Didn't Exist In The Material Library, Create A Fresh Material Now
  if LOCmat == undefined then
  (
    LOCmat          = multiMaterial()
    LOCmat.name     = DYNmatNameVehicles
    LOCmat.count    = 27

    /* ADD DIFFUSE BODY COLOUR VARIABLES Civil View 4.1 */
    /* -------------------------------------------------- */
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourRval" "4")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourGval" "61")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourBval" "4")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourRval" "0")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourGval" "25")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourBval" "185")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourRval" "49")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourGval" "73")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourBval" "230")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourRval" "112")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourGval" "103")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourBval" "92")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourRval" "255")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourGval" "255")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourBval" "255")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourRval" "3")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourGval" "3")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourBval" "3")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourRval" "169")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourGval" "19")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourBval" "3")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourRval" "64")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourGval" "11")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourBval" "6")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourRval" "226")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourGval" "245")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourBval" "4")

    local LOCbodyBase1Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourRval") as integer
    local LOCbodyBase1Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourGval") as integer
    local LOCbodyBase1Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourBval") as integer

    local LOCbodyBase2Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourRval") as integer
    local LOCbodyBase2Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourGval") as integer
    local LOCbodyBase2Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourBval") as integer

    local LOCbodyBase3Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourRval") as integer
    local LOCbodyBase3Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourGval") as integer
    local LOCbodyBase3Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourBval") as integer

    local LOCbodyBase4Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourRval") as integer
    local LOCbodyBase4Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourGval") as integer
    local LOCbodyBase4Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourBval") as integer

    local LOCbodyBase5Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourRval") as integer
    local LOCbodyBase5Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourGval") as integer
    local LOCbodyBase5Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourBval") as integer

    local LOCbodyBase6Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourRval") as integer
    local LOCbodyBase6Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourGval") as integer
    local LOCbodyBase6Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourBval") as integer

    local LOCbodyBase7Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourRval") as integer
    local LOCbodyBase7Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourGval") as integer
    local LOCbodyBase7Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourBval") as integer

    local LOCbodyBase8Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourRval") as integer
    local LOCbodyBase8Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourGval") as integer
    local LOCbodyBase8Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourBval") as integer

    local LOCbodyBase9Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourRval") as integer
    local LOCbodyBase9Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourGval") as integer
    local LOCbodyBase9Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourBval") as integer

    --- Set Up Array of Diffuse Colours
    local LOCdiffuseCols = #() ; LOCdiffuseCols[LOCmat.count] = undefined
    LOCdiffuseCols[1]   = color LOCbodyBase1Rval LOCbodyBase1Gval LOCbodyBase1Bval
    LOCdiffuseCols[2]   = color LOCbodyBase2Rval LOCbodyBase2Gval LOCbodyBase2Bval
    LOCdiffuseCols[3]   = color LOCbodyBase3Rval LOCbodyBase3Gval LOCbodyBase3Bval
    LOCdiffuseCols[4]   = color LOCbodyBase4Rval LOCbodyBase4Gval LOCbodyBase4Bval
    LOCdiffuseCols[5]   = color LOCbodyBase5Rval LOCbodyBase5Gval LOCbodyBase5Bval
    LOCdiffuseCols[6]   = color LOCbodyBase6Rval LOCbodyBase6Gval LOCbodyBase6Bval
    LOCdiffuseCols[7]   = color LOCbodyBase7Rval LOCbodyBase7Gval LOCbodyBase7Bval
    LOCdiffuseCols[8]   = color LOCbodyBase8Rval LOCbodyBase8Gval LOCbodyBase8Bval
    LOCdiffuseCols[9]   = color LOCbodyBase9Rval LOCbodyBase9Gval LOCbodyBase9Bval
    LOCdiffuseCols[10]  = (color 167 0 28)
    LOCdiffuseCols[11]  = (color 38 38 38)
    LOCdiffuseCols[12]  = (color 90 90 90)
    LOCdiffuseCols[13]  = (color 0 0 0)
    LOCdiffuseCols[14]  = (color 165 210 207) * 1.05
    LOCdiffuseCols[15]  = (color 0 0 0)
    LOCdiffuseCols[16]  = (color 47 47 47) * 1.05
    LOCdiffuseCols[17]  = (color 38 38 38)
    LOCdiffuseCols[18]  = (color 215 215 219) * 1.05
    LOCdiffuseCols[19]  = (color 229 206 79) * 1.05
    LOCdiffuseCols[20]  = (color 146 31 0) * 1.05
    LOCdiffuseCols[21]  = (color 234 226 6) * 1.05
    LOCdiffuseCols[22]  = (color 234 226 6) * 1.05
    LOCdiffuseCols[23]  = (color 38 38 38)
    LOCdiffuseCols[24]  = (color 250 250 220)
    LOCdiffuseCols[25]  = (color 254 238 132) * 1.05
    LOCdiffuseCols[26]  = (color 128 128 128)
    LOCdiffuseCols[27]  = (color 150 150 150) * 1.05

    --- Set Up Array of Ambient Colours
    local LOCambientCols = #() ; LOCambientCols[LOCmat.count] = undefined
    for i = 1 to LOCambientCols.count do LOCambientCols[i] = LOCdiffuseCols[i] * 0.85
    LOCambientCols[14] = color  26  26  26
    LOCambientCols[23] = color  26  60 146

    --- Set Up Array of Specular Colours
    local LOCspecularCols = #() ; LOCspecularCols[LOCmat.count] = undefined
    for i = 1 to LOCspecularCols.count do LOCspecularCols[i] = (color 249 249 249)
    LOCspecularCols[23] = color 175 155 250
    LOCspecularCols[24] = color 250 250 100

    if (DYNFUNisMentalRayProductionRenderer()) then
    (
    /*
   DYNFUNbuildArchDesignMat FUNmatName FUNdiffuseColor FUNdiffuseMap FUNbumpMap FUNcutOutMap FUNmapBlur FUNuseRealWorldScale \
   FUNdiffuseRough FUNdiffuseWeight FUNreflWeight FUNreflGloss FUNreflSamples FUNmetalReflectSwitch  FUNbumpMapPercent \
   FUNanisoAmount FUNanisoAngle FUNselfIllumSwitch FUNselfIllimAmount FUNselfIllumVisibleInScene FUNselfIllumVisibleInReflections \
   FUNbdrfDeg00 FUNbdrfDeg90 FUNbdrfCurveShape FUNtwoSided FUNwAngle FUNoverrideCutoutMapWithDiffuseAlpha \
   FUNuTiling FUNvTiling FUNuOffset FUNvOffset FUNdiffuseMixMap FUNdiffuseMixAmount =


    */
      LOCmat[1]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[1]  LOCdiffuseCols[1]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[2]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[2]  LOCdiffuseCols[2]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[3]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[3]  LOCdiffuseCols[3]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[4]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[4]  LOCdiffuseCols[4]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[5]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[5]  LOCdiffuseCols[5]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[6]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[6]  LOCdiffuseCols[6]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[7]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[7]  LOCdiffuseCols[7]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[8]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[8]  LOCdiffuseCols[8]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[9]  = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[9]  LOCdiffuseCols[9]  undefined undefined undefined 1.0 false 0.0 1.0 0.7 0.9 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[10] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[10] LOCdiffuseCols[10] undefined undefined undefined 1.0 false 0.0 1.0 0.3 0.3 8 true 30 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[11] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[11] LOCdiffuseCols[11] undefined undefined undefined 1.0 false 0.0 1.0 1.0 1.0 0 true 30 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[12] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[12] LOCdiffuseCols[12] undefined undefined undefined 1.0 false 0.0 1.0 0.3 0.3 8 true 30 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[13] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[13] LOCdiffuseCols[13] undefined undefined undefined 1.0 false 0.0 1.0 0.3 0.3 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[14] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[14] LOCdiffuseCols[14] undefined undefined undefined 1.0 false 0.0 1.0 0.5 0.5 8 true 30 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[15] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[15] LOCdiffuseCols[15] undefined undefined undefined 1.0 false 0.3 1.0 0.3 0.3 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[16] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[16] LOCdiffuseCols[16] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[17] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[17] LOCdiffuseCols[17] undefined undefined undefined 1.0 false 0.5 1.0 1.0 0.5 8 true 30 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[18] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[18] LOCdiffuseCols[18] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[19] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[19] LOCdiffuseCols[19] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[20] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[20] LOCdiffuseCols[20] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[21] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[21] LOCdiffuseCols[21] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[22] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[22] LOCdiffuseCols[22] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[23] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[23] LOCdiffuseCols[23] undefined undefined undefined 1.0 false 0.0 1.0 1.0 1.0 0 true 30 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[24] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[24] LOCdiffuseCols[24] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[25] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[25] LOCdiffuseCols[25] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[26] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[26] LOCdiffuseCols[26] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[27] = DYNFUNbuildArchDesignMat DYNuiResourcesMaterials[27] LOCdiffuseCols[27] undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0

      LOCmat.materiallist[10].refl_func_high              = 0.5
      LOCmat.materiallist[10].opts_backface_cull          = false

      LOCmat.materialList[11].refr_color                  = (color 0 0 0)
      LOCmat.materialList[11].refl_func_low               = 0.92
      LOCmat.materialList[11].opts_do_refractive_caustics = true
      LOCmat.materialList[11].opts_backface_cull          = false

      LOCmat.materiallist[12].refl_func_high              = 0.5
      LOCmat.materiallist[12].opts_backface_cull          = false

      LOCmat.materiallist[13].refl_func_high              = 0.5
      LOCmat.materiallist[13].opts_backface_cull          = false

      LOCmat.materialList[15].refl_func_high              = 0.5
      LOCmat.materialList[15].opts_backface_cull          = false

      LOCmat.materiallist[17].refr_color                  = (color 208 228 237)
      LOCmat.materiallist[17].refl_func_fresnel           = true
      LOCmat.materiallist[17].refl_func_low               = 0.7
      LOCmat.materiallist[17].opts_backface_cull          = false

      LOCmat.materiallist[23].refr_color                  = (color 0 0 0)
      LOCmat.materiallist[23].refl_func_low               = 0.92
      LOCmat.materiallist[23].refl_func_high              = 1.0
      LOCmat.materiallist[23].opts_do_refractive_caustics = true
      LOCmat.materiallist[23].opts_backface_cull          = false
    )
    else
    (
      LOCmat[1]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[1]  LOCambientCols[1]  LOCdiffuseCols[1]  LOCspecularCols[1]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[2]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[2]  LOCambientCols[2]  LOCdiffuseCols[2]  LOCspecularCols[2]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[3]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[3]  LOCambientCols[3]  LOCdiffuseCols[3]  LOCspecularCols[3]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[4]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[4]  LOCambientCols[4]  LOCdiffuseCols[4]  LOCspecularCols[4]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[5]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[5]  LOCambientCols[5]  LOCdiffuseCols[5]  LOCspecularCols[5]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[6]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[6]  LOCambientCols[6]  LOCdiffuseCols[6]  LOCspecularCols[6]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[7]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[7]  LOCambientCols[7]  LOCdiffuseCols[7]  LOCspecularCols[7]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[8]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[8]  LOCambientCols[8]  LOCdiffuseCols[8]  LOCspecularCols[8]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[9]  = DYNFUNbuildStdMat DYNuiResourcesMaterials[9]  LOCambientCols[9]  LOCdiffuseCols[9]  LOCspecularCols[9]  5 undefined undefined undefined 100 0 1.0 false 100 60 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[10] = DYNFUNbuildStdMat DYNuiResourcesMaterials[10] LOCambientCols[10] LOCdiffuseCols[10] LOCspecularCols[10] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[11] = DYNFUNbuildStdMat DYNuiResourcesMaterials[11] LOCambientCols[11] LOCdiffuseCols[11] LOCspecularCols[11] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[12] = DYNFUNbuildStdMat DYNuiResourcesMaterials[12] LOCambientCols[12] LOCdiffuseCols[12] LOCspecularCols[12] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[13] = DYNFUNbuildStdMat DYNuiResourcesMaterials[13] LOCambientCols[13] LOCdiffuseCols[13] LOCspecularCols[13] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[14] = DYNFUNbuildStdMat DYNuiResourcesMaterials[14] LOCambientCols[14] LOCdiffuseCols[14] LOCspecularCols[14] 1 undefined undefined undefined 100 0 1.0 false  65 20 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[15] = DYNFUNbuildStdMat DYNuiResourcesMaterials[15] LOCambientCols[15] LOCdiffuseCols[15] LOCspecularCols[15] 1 undefined undefined undefined 100 0 1.0 false  70 25 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[16] = DYNFUNbuildStdMat DYNuiResourcesMaterials[16] LOCambientCols[16] LOCdiffuseCols[16] LOCspecularCols[16] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[17] = DYNFUNbuildStdMat DYNuiResourcesMaterials[17] LOCambientCols[17] LOCdiffuseCols[17] LOCspecularCols[17] 0 undefined undefined undefined 100 0 1.0 false 170 90 0.0   0  90 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[18] = DYNFUNbuildStdMat DYNuiResourcesMaterials[18] LOCambientCols[18] LOCdiffuseCols[18] LOCspecularCols[18] 0 undefined undefined undefined 100 0 1.0 false  90 65 0.0  10  85 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[19] = DYNFUNbuildStdMat DYNuiResourcesMaterials[19] LOCambientCols[19] LOCdiffuseCols[19] LOCspecularCols[19] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0  85 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[20] = DYNFUNbuildStdMat DYNuiResourcesMaterials[20] LOCambientCols[20] LOCdiffuseCols[20] LOCspecularCols[20] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0  40  85 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[21] = DYNFUNbuildStdMat DYNuiResourcesMaterials[21] LOCambientCols[21] LOCdiffuseCols[21] LOCspecularCols[21] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[22] = DYNFUNbuildStdMat DYNuiResourcesMaterials[22] LOCambientCols[22] LOCdiffuseCols[22] LOCspecularCols[22] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[23] = DYNFUNbuildStdMat DYNuiResourcesMaterials[23] LOCambientCols[23] LOCdiffuseCols[23] LOCspecularCols[23] 4 undefined undefined undefined 100 0 1.0 false 155 50 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[24] = DYNFUNbuildStdMat DYNuiResourcesMaterials[24] LOCambientCols[24] LOCdiffuseCols[24] LOCspecularCols[24] 0 undefined undefined undefined 100 0 1.0 false  90 65 0.0 100  85 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[25] = DYNFUNbuildStdMat DYNuiResourcesMaterials[25] LOCambientCols[25] LOCdiffuseCols[25] LOCspecularCols[25] 1 undefined undefined undefined 100 0 1.0 false   5 25 0.0   0  85 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[26] = DYNFUNbuildStdMat DYNuiResourcesMaterials[26] LOCambientCols[26] LOCdiffuseCols[26] LOCspecularCols[26] 1 undefined undefined undefined 100 0 1.0 false   0  0 0.0   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmat[27] = DYNFUNbuildStdMat DYNuiResourcesMaterials[27] LOCambientCols[27] LOCdiffuseCols[27] LOCspecularCols[27] 1 undefined undefined undefined 100 0 1.0 false   0  0 0.0   0   0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0

      --- Add Body Color Raytracing
      local LOCrefMap = raytrace()
      LOCrefMap.name  = DYNuiResourcesMaterialMaps[9]
      for i = 1 to 9 do
      (
        LOCmat.materiallist[i].reflectionMap       = LOCrefMap
        LOCmat.materiallist[i].reflectionMapAmount = rootNode.DYNrootNodeStore.vehRayAmount
        LOCmat.materiallist[i].reflectionMapEnable = rootNode.DYNrootNodeStore.vehRayTrace
      )

      --- Extra Stuff
      LOCmat.materiallist[17].diffuseLevel         = 89
      LOCmat.materiallist[18].diffuseLevel         = 100
      LOCmat.materiallist[23].diffuseLevel         = 115
      LOCmat.materiallist[24].diffuseLevel         = 100

      LOCmat.materiallist[17].reflectionMap        = LOCrefMap
      LOCmat.materiallist[17].reflectionMapAmount  = 40
      LOCmat.materiallist[23].reflectionMap        = LOCrefMap
      LOCmat.materiallist[23].reflectionMapAmount  = 50

      LOCmat.materiallist[17].anisotropy           = 63
      LOCmat.materiallist[17].orientation          = 7

      LOCmat.materiallist[18].anisotropy           = 20
      LOCmat.materiallist[18].orientation          = 0

      LOCmat.materiallist[24].anisotropy           = 20
      LOCmat.materiallist[24].orientation          = 0
    )


    --- Set Names In MultiMaterial
    for i = 1 to LOCmat.count do
    (
      LOCmat.names[i] = LOCmat.materialList[i].name
    )

    --- Attempt to Save Material To Civil View Material Library
    local LOCmatLibrary = materialLibrary LOCmat
    local LOCsuccess    = saveTempMaterialLibrary LOCmatLibrary LOCcivilViewVehiclesMatFile
  )

  --- Show Texture Maps In Viewport
  if classOf LOCmat == Multimaterial then (for i = 1 to LOCmat.count do (DYNFUNshowTextureMap LOCmat i false on))

  LOCmat -- return value
)
